/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CIcon.cpp,v 1.2 1999/12/05 02:23:34 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include "CIcon.h"

_USING_PGP

// Class CIcon public member functions

void 
CIcon::Load(HINSTANCE instance, const char *name, PGPBoolean shared)
{
	Clear();

	mIcon = static_cast<HICON>(
		LoadImage(instance, name, IMAGE_ICON, 0, 0, shared ? LR_SHARED : 0));

	if (IsNull(mIcon))
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());

	mWeCreated = TRUE;
}

void 
CIcon::Attach(HICON icon, PGPBoolean weOwn)
{
	if (mIcon == icon)
		return;

	Clear();

	mWeCreated = weOwn;
	mIcon = icon;
}

void 
CIcon::Clear()
{
	if (WeCreated())
		DestroyIcon(mIcon);

	mWeCreated = FALSE;
	mIcon = NULL;
}
